#include "stdafx.h"
#include "Command_Parse.h"


char parse_array[MAX_COMMAND_LINE][MAX_COMMAND_DEEP][20] = { {"Show", "Information", "End"},	
														     {"Record", "Start", "End"},
														     {"Record", "Stop" , "End"},
															 {"Share", "Record", "Start", "End"},
															 {"Share", "Record", "Change", "End"}, 
															 {"Share", "Record", "Stop", "End"}, 
															 {"Snapshot", "Jpg", "End"},
															 {"Snapshot", "Bmp", "End"},
															 {"Config", "Input", "Video", "End"},
															 {"Config", "Input", "Audio", "End"}, 															 
															 {"Exit", "End"},
															 {"Create","Device", "End"}};


int strcasecmp(char *s1, char *s2)
{
   while  (toupper((unsigned char)*s1) == toupper((unsigned char)*s2++))
       if (*s1++ == ' ') return 0;
   return(toupper((unsigned char)*s1) - toupper((unsigned char)*--s2));
}


int strncasecmp(char *s1, char *s2, register int n)
{
  while (--n >= 0 && toupper((unsigned char)*s1) == toupper((unsigned char)*s2++))
      if (*s1++ == ' ')  return 0;
  return(n < 0 ? 0 : toupper((unsigned char)*s1) - toupper((unsigned char)*--s2));
}


struct command_s Command_parse_func( char *org_command, ULONG command_len)
{	
	int idx=0, deep=0, match_falg = 0;

	struct command_s command1;
	memset(&command1, 0x00, sizeof(command1));

	char str_temp[MAX_COMMAND_LEN];
	memcpy( str_temp , org_command , sizeof(str_temp));

	char *pch, *delim = " ";
	
	pch = strtok (str_temp, delim);	
	
	// Command Match 
	while(pch != NULL)
	{

		while(idx < MAX_COMMAND_LINE){

			if(strncasecmp(pch, parse_array[idx][deep], strlen(pch)) == 0){
				// Match
				deep ++;
				
				if(strcmp( parse_array[idx][deep], "End") == 0){
					command1.execute_command = idx;
					match_falg = 1;					
					command1.execute_status = true;   					
				}
				
				break; // To get a new pch
			}else {
				// Unmatch
				// Init deep and pch, go next idx
				memcpy( str_temp , org_command , sizeof(str_temp));
				pch = strtok (str_temp, delim);
				deep = 0;
				idx ++;

			}
		}
		pch = strtok (NULL, delim);


		if(match_falg) break;

	}

	// Arguement Append.txt
	while(pch != NULL && match_falg) {			
		
		if( atoi(pch) > 0 && atoi(pch) < MAX_CHANNEL_NUM +1 ) {
			command1.execute_channel_flag[atoi(pch)-1] = true;	
			command1.execute_status = true;   	
		}

		if(strncasecmp( pch, "-avi", strlen(pch)) == 0){			
			command1.execute_format = CONFIG_FORMAT_AVI;
		}

		if(strncasecmp( pch, "-mp4", strlen(pch)) == 0){ 
			command1.execute_format = CONFIG_FORMAT_MP4;			
		}

		if(strncasecmp( pch, "-gpu", strlen(pch)) == 0){
			command1.execute_enable_gpu = true;			
		}

		pch = strtok (NULL, delim);
	}

		
	return command1;
}
